/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.gui.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import ht.treechop.client.gui.element.NestedGui;
import ht.treechop.client.gui.widget.TextWidget;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.util.text.ITextComponent;

public class LabeledGui
extends NestedGui {
    private static final int COLUMN_PADDING = 4;
    private final TextWidget label;
    private final NestedGui gui;
    private int leftColumnWidth;
    private int rightcolumnWidth;
    private boolean rightAlignLabels = false;

    public LabeledGui(FontRenderer font, ITextComponent label, NestedGui gui) {
        this.label = new TextWidget(0, 0, font, label);
        this.gui = gui;
        this.leftColumnWidth = this.getLeftColumnWidth();
        this.rightcolumnWidth = this.getRightColumnWidth();
    }

    @Override
    public int getMinimumWidth() {
        return this.getLeftColumnWidth() + this.gui.getMinimumWidth();
    }

    @Override
    public int getMinimumHeight() {
        return Math.max(this.label.func_238483_d_(), this.gui.getMinimumHeight());
    }

    @Override
    public int getLeftColumnWidth() {
        return this.label.func_230998_h_() + 4;
    }

    @Override
    public int getRightColumnWidth() {
        return this.gui.getMinimumWidth() + 4;
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return Stream.of(Collections.singletonList(this.label), this.gui.func_231039_at__()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int center = this.getBox().getCenterX() + (this.leftColumnWidth - this.rightcolumnWidth) / 2;
        this.label.field_230690_l_ = center - 4 + (this.rightAlignLabels ? 0 : -this.leftColumnWidth);
        this.label.field_230691_m_ = this.getBox().getCenterY() - 3;
        this.label.render(matrixStack, mouseX, mouseY, partialTicks, this.rightAlignLabels);
        this.gui.setBox(center + 4, this.getBox().getTop(), this.rightcolumnWidth, this.getBox().getHeight());
        this.gui.render(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void setColumnWidths(int biggestLeftColumnWidth, int biggestRightColumnWidth) {
        this.leftColumnWidth = biggestLeftColumnWidth;
        this.rightcolumnWidth = biggestRightColumnWidth;
    }
}

